/*****************************************************************************
 *
 * AIX 3.2 Internationalization Sample Environment Package
 *
 * (C) COPYRIGHT International Business Machines Corp. 1989 All Rights Reserved
 *
 * US Government Users Restricted Rights - Use, duplication or disclosure 
 * restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * INTERNATIONAL BUSINESS MACHINES CORPORATION PROVIDES THIS PACKAGE OF SAMPLE
 * ENVIRONMENT FILES, BOTH INDIVIDUALLY AND AS ONE OR MORE GROUPS, AS IS, 
 * WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING, BUT NOT
 * LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE. THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE 
 * SAMPLE ENVIRONMENT FILES, BOTH INDIVIDUALLY AND AS ONE OR MORE GROUPS, IS
 * WITH YOU. SHOULD ANY PART OF THE SAMPLE ENVIRONMENT PACKAGE PROVE DEFECTIVE,
 * YOU (AND NOT IBM) ASSUME THE ENTIRE COST OF ALL NECESSARY SERVICE, SUPPORT,
 * REPAIR OR CORRECTION.
 *
 * Each copy of the AIX 3.2 ILS Sample Environment Package or derivative work
 * thereof must reproduce the IBM Copyright notice and the complete contents of
 * this notice.
 *
 *****************************************************************************/

/* getCS.c -- Routine that determines the codeset of a certain locale.
   Use -- getCS <LOCALE>						     */
 
#include <locale.h>
#include <langinfo.h>

main (int argc, char* argv[])
{
    char *ret_ptr;

    if (argc != 2) {
	printf("Usage: getCS <LOCALE>\n");
	return;
    }

    ret_ptr = setlocale(LC_ALL, argv[1]);   /* NLS defined routine */

    if (ret_ptr == NULL)
	printf("Error in setting up locale.\n");
    else
	printf("%s\n", nl_langinfo(CODESET));

    return;
}
    

